/* $Header: CGMLToSDO.java 30-oct-2006.19:48:12 rkothuri Exp $ */

/* Copyright (c)  2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rkothuri     10/30/06 - Creation
 */

/**
 *  @version $Header: CGMLToSDO.java 30-oct-2006.19:48:12 rkothuri Exp $
 *  @author  rkothuri 
 *  @since   release specific (what release of product did this appear in)
 */

import oracle.spatial.util.*;
//import oracle.spatial.util.GML;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.*;
import java.util.*;
import oracle.jdbc.*;
import java.sql.*;
import oracle.spatial.geometry.*;

import oracle.sql.CLOB;

import oracle.sql.STRUCT;

import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.DOMParser;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
//import oracle.spatial.geometry.*;
import org.w3c.dom.NodeList;

import org.xml.sax.SAXException;

//package oracle.spatial.CGMLToSDO;

public class CGMLToSDO extends GML
{

    private static String host = "stadb28.us.oracle.com";
    private static String port = "1521";
    private static String sid = "sdo";
    private static String driver = "thin";
    private static String user = "scott";
    private static String password = "tiger";
    private static String fTable = "CityObjectMembers";
    private static String geomTable = "Geometries";
    private static String geomCol = "Geom";
    private static String fCol = "Feature";
    private static String inpfile = "CityGMLToSDO.gml";
    private static  Connection connection = null;

    
    /*************************************************************************/
    static private String usage()
    {
      return "Usage: java CGMLToSDO \n" +
             "-host hostName \n-port portNumber\n" +
             "-sid SID \n-driver jdbcDriver[thin:oci]\n" +
             "-user userName\n" +
             "-password password\n" +
             "-comp_table tablename \n" +
             "-feat_table tablename \n" +
             "-geomcol sdo_geometry\n" +
             "-featurecol xmltype\n" +
             "-file inpfile\n"; 
    }

    /*************************************************************************/
    public static void setConnection(){
      String connectString =
                "jdbc:oracle:" + driver + ":@"
                + "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(HOST="
                +  host + ")"
                + "(PROTOCOL=tcp)(PORT="
                + port + ")))"
                + "(CONNECT_DATA=(SID="
                + sid + ")))";
                                                                                 
      try {
        DriverManager.registerDriver(new OracleDriver());
        connection = DriverManager.getConnection(
                       connectString, user, password);
                                                                                 
      }
      catch (Throwable t)
      {
        System.out.println(
                        t.toString() + ": \n" + t.getMessage() +
                        "Error attempting to connect to database");
       }

     }
    /*************************************************************************/
    public static Connection getConnection() { return connection; }

    /*************************************************************************/
    private static void processCmdLineArgs(String[] args)
    {
                                                                                 
        // process db connection information
      
          if ( args.length > 0  )
         {
            for ( int i = 0 ; i < args.length ;i++ )
            {
              if ( args[i].equalsIgnoreCase("-host") )
                host = args[++i];
              else if ( args[i].equalsIgnoreCase("-port") )
                port = args[++i];
              else if ( args[i].equalsIgnoreCase("-sid") )
                sid = args[++i];
              else if ( args[i].equalsIgnoreCase("-driver") )
                driver = args[++i];
              else if ( args[i].equalsIgnoreCase("-user") )
                user = args[++i];
              else if ( args[i].equalsIgnoreCase("-password") )
                password = args[++i];
              else if ( args[i].equalsIgnoreCase("-file") ) 
                inpfile = args[++i];
              else if ( args[i].equalsIgnoreCase("-comp_table") ) 
                geomTable = args[++i];
             else if ( args[i].equalsIgnoreCase("-feat_table") ) 
                 fTable = args[++i];
              else if ( args[i].equalsIgnoreCase("-geomcol") ) 
                geomCol= args[++i];
              else if ( args[i].equalsIgnoreCase("-featurecol") ) 
                fCol= args[++i];
              else if ( args[i].equalsIgnoreCase("-h") )
              {
                 System.out.println(usage());
                 System.exit(0);
              }
           }
         }
	 else {
                System.out.println("Using default parameters: reading from CityGMLToSDO.gml");
         }
         setConnection();
      
    }
    /*************************************************************************/

     private static  boolean match(String ndName, String geometryTypes[]) {
         
          int len = geometryTypes.length;
          for(int i=0; i< len; i++)
             if (ndName.equalsIgnoreCase(geometryTypes[i]))
                return true;
          return false;
     }
     private static CLOB getCLOB(XMLDocument d, Connection conn) throws SQLException{
          CLOB tempClob = null;
          String xmlData;
          try{
            // If the temporary CLOB has not yet been created, create new
            tempClob = CLOB.createTemporary(conn, true, CLOB.DURATION_SESSION);

            // Open the temporary CLOB in readwrite mode to enable writing
            tempClob.open(CLOB.MODE_READWRITE);
            // Get the output stream to write
            Writer tempClobWriter = null;
            tempClobWriter = tempClob.getCharacterOutputStream();
            // Write the data into the temporary CLOB
            d.print(tempClobWriter);
            //tempClobWriter.write(xmlData);

            // Flush and close the stream
            tempClobWriter.flush();
            tempClobWriter.close();

            // Close the temporary CLOB
            tempClob.close();    
          } catch(SQLException sqlexp){
            tempClob.freeTemporary();
            sqlexp.printStackTrace();
          } catch(Exception exp){
            tempClob.freeTemporary();
            exp.printStackTrace();
          }
          return tempClob;
        } 
     
     public static void writeFeat(int id, XMLDocument d) {
       final Connection conn = getConnection();
       PreparedStatement  stmt = null;
       String sqlStr =
         " insert into "+ fTable + " values (?, XMLTYPE(?))";
       try
       {
           //System.out.println(sqlStr);
         conn.setAutoCommit(true);
         stmt = conn.prepareCall(sqlStr);
        
         CLOB clob = getCLOB(d, conn);                                
         stmt.setInt(1, id);
         stmt.setObject(2, clob);
         stmt.executeUpdate();
                                                                                         
       }
       catch ( SQLException e1 )
         { System.out.println("Error: "+e1.getMessage());}
       finally {                        
         try {
           if (stmt !=null)     {stmt.close(); stmt = null;}
         } catch ( SQLException e ) {}
       }  
     }
     
     public static void writegm(int featid, int gmid, JGeometry gm) {
         final Connection conn = getConnection();
         PreparedStatement  stmt = null;
         String sqlStr =
           " insert into "+ geomTable + " values (?, ?, ?)";
         try
         {
             //System.out.println(sqlStr);
           conn.setAutoCommit(true);
           stmt = conn.prepareCall(sqlStr);
           STRUCT dbobj = JGeometry.store(gm, conn);   
                               
           stmt.setInt(1, featid);
           stmt.setInt(2, gmid);
           stmt.setObject(3, dbobj);
           stmt.executeUpdate();
                                                                                           
         }
         catch ( SQLException e1 )
           { System.out.println("Error: "+e1.getMessage());}
         finally {  
           try {
             if (stmt !=null)     {stmt.close(); stmt = null;}
           } catch ( SQLException e ) {}
         }      
     }
     public static Vector getGeometry(
       Node    start,
       String  geometryTypes[])
     {
       Vector result = new Vector();
       getGeometry(start, geometryTypes, result);
       return result;
     }
                                                                                    
     public static void getGeometry(
       Node    start,
       String  geometryTypes[],
       Vector  result)
     {
       for(Node child = start.getFirstChild();
           child != null;
           child = child.getNextSibling())
       {
         String str = new String(child.getNodeName());
         System.out.println(str);
         if(match(str, geometryTypes))
         //normalize(child.getNodeName()).equalsIgnoreCase(path[posInPath]))
         {        
             result.add(child);
         }
         else
           getGeometry(child, geometryTypes, result);
       }
     }
                        
    public static XMLDocument getXMLDocFromNode(Node nd) throws IOException {                                                            
      XMLDocument d =  new XMLDocument();
      Node dRoot = d.importNode(nd, true);
      d.appendChild(dRoot);
      String str = d.toString();
      //d.print(System.out);
    
      return d;
    }

  public static void main(String args[])
    throws
      FileNotFoundException,
      IOException,
      SAXException 
  {    
   
    processCmdLineArgs(args);
    
    DOMParser parser = new DOMParser();
    parser.parse(new FileInputStream(inpfile));
    XMLDocument doc = parser.getDocument();
    NodeList ndlst =  doc.getElementsByTagName("cityObjectMember");

    int ndlen = ndlst.getLength(); // ndlen: number of cityobjectmmebers 
    for(int i=0; i<ndlen; i++)
    {
      Node nd = (Node) ndlst.item(i);
      boolean b = nd.hasAttributes();
     
      NamedNodeMap n= nd.getAttributes();
      
      for(int k=0; k<n.getLength(); k++) {
          Node sn = n.item(k);
          int val = Integer.parseInt(sn.getNodeValue());
          System.out.println(sn.getNodeName() +"= " + val);
      }
      XMLDocument d = getXMLDocFromNode(nd);
      
      d.print(System.out);
      Vector v = getGeometry(nd, new String[] {"gml:MultiSurface", "gml:Polygon"});

      int num_geoms = v.size();
      if (num_geoms > 0)
        writeFeat(i, d);
      for(int j=0; j<v.size(); j++) {
          Node descNd = (Node) v.get(j);
        
          System.out.println(descNd.getNodeName());
          XMLDocument d2 = getXMLDocFromNode(descNd);
          d2.print(System.out); 
          JGeometry gm = null;
          try {
          gm = oracle.spatial.util.GML3g.fromNodeToGeometry(descNd);
          } catch (Exception ex) {ex.printStackTrace();}
          
          writegm(i, j, gm); 
      }          
    } 
  }
}
